/*
Copyright 2008-2009 Elöd Egyed-Zsigmond, Cyril Laitang
Copyright 2009-2011 Samuel Gesche

This file is part of IPRI News Analyzer.

IPRI News Analyzer is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

IPRI News Analyzer is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with IPRI News Analyzer.  If not, see <http://www.gnu.org/licenses/>.
*/

package zold.proc.parsing;

import data.base.Database;
import data.base.connectors.ThesaurusDatabase;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
//rappel: DOM créé un arbre permanent, sax se contente de parcourir le document.
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;


/**
 *
 * @author claitang1
 */
public class _IPTCParser {

    private List tuple;
    private ArrayList lvl1, lvl2;
    private int conceptID, niveau;
    private Database theDB;

    public _IPTCParser(Database db){
        theDB = db;
        lvl1 = new ArrayList();
        lvl2 = new ArrayList();
        conceptID = 0;
        niveau = 0;
    }
    public void parseFile(String file) throws SAXException, IOException {
        //initialisation du parseur XML
        XMLReader parser = XMLReaderFactory.createXMLReader();
        DocumentHandler handler = new DocumentHandler();
        parser.setContentHandler(handler);
        parser.parse(file);
    }

    class DocumentHandler extends DefaultHandler{

        boolean content = false;
        boolean subjectCode = false;

        @Override
        public void startElement (String uri, String localName,
                      String qName, Attributes attributes) throws SAXException {
            //verifie si il s'agit du subject code.
            if(qName.equalsIgnoreCase("FormalName") && attributes.getValue(0).equalsIgnoreCase("IptcSubjectCodes")){
                subjectCode = true;
                tuple = new ArrayList();
            }
            // verifie que nous somme face au contenu correspondant au code et en francais.
            if(qName.equalsIgnoreCase("description")){
               if(attributes.getValue(0).equalsIgnoreCase("fr") && (
                 attributes.getValue(1).equalsIgnoreCase("Name")
                 || attributes.getValue(1).equalsIgnoreCase("Explanation"))){
                    content = true;
               }
            }

        }

        @Override
        public void characters(char[] ch, int start, int length){
            String result = new String(ch, start, length);
            ThesaurusDatabase td = new ThesaurusDatabase(theDB);
            //creation des concepts dans la base
            if(content){
                tuple.add(result);
                if(tuple.size()==2){
                    //conceptID = td.saveConcept(tuple.get(0).toString(), tuple.get(1).toString(), 1);
                    //creation des liens hierarchiques entre concepts dans la base
                    switch(niveau){
                        case 1:
                            insertHierarchie(lvl1, td);
                            lvl1 = new ArrayList();
                            lvl1.add(conceptID);
                            break;
                        case 2:
                            insertHierarchie(lvl2, td);
                            lvl1.add(conceptID);
                            lvl2 = new ArrayList();
                            lvl2.add(conceptID);
                            break;
                        case 3:
                            lvl2.add(conceptID);
                            break;
                    }
                }
            }
            //creation des liens hierarchiques entre concepts dans la base
            if(subjectCode){
                niveau = getHierarchie(result);
            }
        }

        private void insertHierarchie(ArrayList liste, ThesaurusDatabase td){
            if(!liste.isEmpty()){
                for(int i = 1; i < liste.size(); i++){
                    //td.saveRelationship(liste.get(0).toString(), liste.get(i).toString());
                }
            }
        }

        private int getHierarchie(String subjectCode){
            //initialisation des variables et niveaux hierarchiques
            char[] var = subjectCode.toCharArray();
            String hiera1, hiera2, nullVal = new String();
            nullVal = "000";
            hiera1 = var[2]+""+var[3]+""+var[4];
            hiera2 = var[5]+""+var[6]+""+var[7];
            //tests
            if(hiera1.equals(nullVal)){
                //niveau hierarchique 1
                return 1;
            }
            else if(hiera2.equals(nullVal)){
                //niveau hierarchique 2
                return 2;
            }
            else{
                //niveau hierachique 3
                return 3;
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            subjectCode = false;
            content = false;
        }
    }
}
